
#ifndef H_TYPES
 #define H_TYPES

#define NONE    (0)    /* empty board spaces */
#define PLAYER1 (1)
#define PLAYER2 (2)
#define UNOWNED (3)    /* unowned pieces and board spaces */
#define FILLED  (42)   /* used only by cutouts */

typedef struct piece_s piece;
typedef struct cutout_s cutout;
typedef struct board_s board;

struct piece_s {
    int letter;
    int rot;
    int x, y;
    int owner;
};

struct cutout_s {
    int w, h;
    char data[25];
};

struct board_s {
    int turn;
    piece pieces[12];
    int w, h;
    char *data;
};

board *new_board(int w, int h);
board *copy_board(const board *b);
void kill_board(board *b);

piece *piece_of_letter(const board *b, int letter);
piece *piece_of_position(const board *b, int x, int y);

cutout *cutout_of_letter(int letter, int rot);
cutout *cutout_of_piece(const piece *p);
void kill_cutout(cutout *c);

int fits(const board *b, const cutout *c, int x, int y);
void place(board *b, const cutout *c, int x, int y, int who);
void place_piece(board *b, const piece *p);

#endif
