
#include <stdlib.h>
#include "assert.h"
#include "types.h"
#include "moves.h"


int borders(const piece *p, const piece *q)
{
    cutout *cp, *cq;
    int i, j;
    int count = 0;
    assert(p->x >= 0 && q->x >= 0);

    if (p == q) return 0;

    cp = cutout_of_piece(p);
    cq = cutout_of_piece(q);
    assert(cp && cq);

    for (j=0; j < cp->h; ++j) {
        for (i=0; i < cp->w; ++i) {
            int m, n;
            if (cp->data[j*cp->w+i] != FILLED) continue;
            m = (p->x+i) - q->x;
            n = (p->y+j) - q->y;
#define HAS(x, y) ((x) >= 0 && (y) >= 0 && (x) < cq->w && (y) < cq->h && \
                   cq->data[(y)*cq->w+(x)] == FILLED)
            if (HAS(m+1, n)) count += 1;
            if (HAS(m-1, n)) count += 1;
            if (HAS(m, n+1)) count += 1;
            if (HAS(m, n-1)) count += 1;
        }
    }

    return (count >= 3);
}
#undef HAS


/* (x < 0) indicates "remove this letter from the board" */
int move_possible(const board *b, int letter, int rot, int x, int y)
{
    piece *p = piece_of_letter(b, letter);
    if (x < 0) {
        /* Remove only your own placed pieces. */
        return (p->owner == b->turn) && (p->x >= 0);
    }
    else if (p->x >= 0 || p->owner != UNOWNED) {
        /* Can't place placed or owned pieces. */
        return 0;
    }
    else {
        cutout *c = cutout_of_letter(letter, rot);
        int success = fits(b, c, x, y);
        kill_cutout(c);
        return success;
    }
}

/* (x < 0) indicates "remove this letter from the board" */
void make_move(board *b, int letter, int rot, int x, int y)
{
    piece *p = piece_of_letter(b, letter);
    if (x < 0) {
        cutout *c = cutout_of_piece(p);
        assert(p->x >= 0 && p->owner == b->turn);
        place(b, c, p->x, p->y, NONE);
        kill_cutout(c);
        p->x = p->y = -1;
    }
    else {
        int i;
        assert(p->owner == UNOWNED);
        p->x = x; p->y = y; p->rot = rot;
        place_piece(b, p);

        /* See whether any pieces change ownership. */
        for (i=0; i < NELEM(b->pieces); ++i) {
            if (b->pieces[i].x >= 0 &&
                b->pieces[i].owner != b->turn &&
                borders(&b->pieces[i], p))
            {
                b->pieces[i].owner = b->turn;
                place_piece(b, &b->pieces[i]);
            }
        }

        /* After a placing move, the turn updates and pieces expire. */
        b->turn = (b->turn == PLAYER2)? PLAYER1: PLAYER2;
        for (i=0; i < NELEM(b->pieces); ++i) {
            if (b->pieces[i].x < 0)
              b->pieces[i].owner = UNOWNED;
        }
    }
}
