
#include <stdio.h>
#include <stdlib.h>
#include "assert.h"
#include "types.h"
#include "moves.h"
#include "alpha.h"
#include "display.h"

#define randint0(m) (rand() % (m))

static possible_move *pick_random_placement(possible_move *list);


int main(int argc, char **argv)
{
    board *b = new_board(7, 7);
    int alpha_depth = 2;
    int turn_number = 0;
    int computer_plays_first = 0;

    if (argc > 1) {
        alpha_depth = atoi(argv[1]);
        if (argc > 2)
          computer_plays_first = atoi(argv[2]);
        if (argc > 3)
          srand(atoi(argv[2]));
    }

    if (computer_plays_first)
      b->turn = PLAYER2;

    while (1) {
        possible_move *m;

        while (b->turn == PLAYER1) {
            m = eval_alpha_beta_depth(b, 0);  /* Any moves left? */
            if (m == NULL) {
                display_board("You have lost to the computer!", b);
                goto done;
            }
            display_board("Your move.", b);
            m = get_users_move(b);
            make_move(b, m->letter, m->rot, m->x, m->y);
            free(m);
        }

        display_board("Computer's move.", b);
        while (b->turn == PLAYER2) {
            if (turn_number < 2) {
                /* Just pick a random move to speed things up. */
                m = find_all_possible_moves(b);
                assert(m != NULL);
                m = pick_random_placement(m);
            }
            else {
                m = eval_alpha_beta_depth(b, alpha_depth);
            }
            if (m == NULL) {
                display_board("You beat the computer!", b);
                goto done;
            }
            make_move(b, m->letter, m->rot, m->x, m->y);
            if (m->x < 0)
              printf("Computer removes %c.\n\n", m->letter);
            else printf("Computer plays %c.\n\n", m->letter);
            free(m);
        }

        ++turn_number;
    }
  done:

    return 0;
}


static possible_move *
pick_random_placement(possible_move *list)
{
    possible_move *best = NULL;
    int c = 1;
    assert(list);
    while (list != NULL) {
        possible_move *cur = list;
        if (cur->x >= 0 && !randint0(c++)) {
            best = cur;
            cur = NULL;
        }
        list = list->next;
        free(cur);
    }
    assert(best);
    return best;
}
